---
-- Name: AID-008 - AI_A2A - CAP Grouping Test
-- Author: FlightControl
-- Date Created: 06 Aug 2017


-- Define a SET_GROUP object that builds a collection of groups that define the EWR network.
-- Here we build the network with all the groups that have a name starting with DF CCCP AWACS and DF CCCP EWR.
DetectionSetGroup_BLUE = SET_GROUP:New()
DetectionSetGroup_BLUE:FilterPrefixes("FOCUS", "BLUEEWR")
DetectionSetGroup_BLUE:FilterStart()
Detection_BLUE = DETECTION_AREAS:New( DetectionSetGroup_BLUE, 300000 )
Detection_BLUE:SetRefreshTimeInterval( 10 )

A2ADispatcher_BLUE = AI_A2A_DISPATCHER:New( Detection_BLUE )
A2ADispatcher_BLUE:SetEngageRadius( 50000 )


MainBlueZone = ZONE_POLYGON:New( "MainBlueZone", GROUP:FindByName( "Main Blue Zone" ) )
NorthBlueZone = ZONE_POLYGON:New( "NorthBlueZone", GROUP:FindByName( "NorthBlueZone" ) )
BARCAPBLUE = ZONE_POLYGON:New( "BARCAPBLUE", GROUP:FindByName( "BARCAPBLUE" ) )
SouthBlueZone = ZONE_POLYGON:New( "SouthBlueZone", GROUP:FindByName( "SouthBlueZone" ) )
DeepBlueZone = ZONE_POLYGON:New( "DeepBlueZone", GROUP:FindByName( "Deep Blue Zone" ) )
SirjanBlue = ZONE_POLYGON:New( "SirjanBlue", GROUP:FindByName( "Sirjan Blue" ) )

A2ADispatcher_BLUE:SetBorderZone( {MainBlueZone} )


--------------------////CAP Squadrons 


A2ADispatcher_BLUE:SetSquadron( "LarSTRIKE", AIRBASE.PersianGulf.Lar_Airbase, { "A10A", "Predator" }, 10 )

A2ADispatcher_BLUE:SetSquadron( "KishCAP", AIRBASE.PersianGulf.Kish_International_Airport, { "F18C", "F16C", "M20005", "F14B" }, 15 )
A2ADispatcher_BLUE:SetSquadron( "KishBARCAP", AIRBASE.PersianGulf.Kish_International_Airport, { "F15C", "F14B" }, 8 )
A2ADispatcher_BLUE:SetSquadron( "KishBIGDADDY", AIRBASE.PersianGulf.Kish_International_Airport, { "B1", "F117A", "C130" }, 10 )

A2ADispatcher_BLUE:SetSquadron( "SasCARGO", AIRBASE.PersianGulf.Sas_Al_Nakheel_Airport, { "C17A", "C130", "C5" }, 10 )

--These are all airbases of the Persion Gulf Map:

--AIRBASE.PersianGulf.Abu_Dhabi_International_Airport
--AIRBASE.PersianGulf.Abu_Musa_Island_Airport
--AIRBASE.PersianGulf.Al-Bateen_Airport
--AIRBASE.PersianGulf.Al_Ain_International_Airport
--AIRBASE.PersianGulf.Al_Dhafra_AB
--AIRBASE.PersianGulf.Al_Maktoum_Intl
--AIRBASE.PersianGulf.Al_Minhad_AB
--AIRBASE.PersianGulf.Bandar_e_Jask_airfield
--AIRBASE.PersianGulf.Bandar_Abbas_Intl
--AIRBASE.PersianGulf.Bandar_Lengeh
--AIRBASE.PersianGulf.Dubai_Intl
--AIRBASE.PersianGulf.Fujairah_Intl
--AIRBASE.PersianGulf.Havadarya
--AIRBASE.PersianGulf.Jiroft_Airport
--AIRBASE.PersianGulf.Kerman_Airport
--AIRBASE.PersianGulf.Khasab
--AIRBASE.PersianGulf.Kish_International_Airport
--AIRBASE.PersianGulf.Lar_Airbase
--AIRBASE.PersianGulf.Lavan_Island_Airport
--AIRBASE.PersianGulf.Liwa_Airbase
--AIRBASE.PersianGulf.Qeshm_Island
--AIRBASE.PersianGulf.Ras_Al_Khaimah_International_Airport
--AIRBASE.PersianGulf.Sas_Al_Nakheel_Airport
--AIRBASE.PersianGulf.Sharjah_Intl
--AIRBASE.PersianGulf.Shiraz_International_Airport
--AIRBASE.PersianGulf.Sir_Abu_Nuayr
--AIRBASE.PersianGulf.Sirri_Island
--AIRBASE.PersianGulf.Tunb_Island_AFB
--AIRBASE.PersianGulf.Tunb_Kochak

--------------------////Altitude
A2ADispatcher_BLUE:SetDefaultTakeoffInAirAltitude( 6900 )

--------------------////TAKEOFF

A2ADispatcher_BLUE:SetSquadronTakeoffInAir( "LarSTRIKE" )


A2ADispatcher_BLUE:SetSquadronTakeoffInAir( "KishCAP" )
A2ADispatcher_BLUE:SetSquadronTakeoffFromParkingCold( "KishBARCAP" )
A2ADispatcher_BLUE:SetSquadronTakeoffInAir( "KishBIGDADDY" )

A2ADispatcher_BLUE:SetSquadronTakeoffInAir( "SasCARGO" )


--------------------////LANDING


A2ADispatcher_BLUE:SetSquadronLandingNearAirbase( "LarSTRIKE" )

A2ADispatcher_BLUE:SetSquadronLandingNearAirbase( "KishCAP" )
A2ADispatcher_BLUE:SetSquadronLandingNearAirbase( "KishBARCAP" )
A2ADispatcher_BLUE:SetSquadronLandingNearAirbase( "KishBIGDADDY" )

A2ADispatcher_BLUE:SetSquadronLandingNearAirbase( "SasCARGO" )





--------------------Timing Originally 300/750

A2ADispatcher_BLUE:SetSquadronCap( "LarSTRIKE", SouthBlueZone, 3000, 12000, 800, 1100, 1000, 1500, "BARO" )
A2ADispatcher_BLUE:SetSquadronCapInterval( "LarSTRIKE", 1, 1, 1200, 1 )


A2ADispatcher_BLUE:SetSquadronGci( "KishCAP", 900, 1200 )
A2ADispatcher_BLUE:SetSquadronCap( "KishBARCAP", BARCAPBLUE, 9000, 11000, 600, 900, 1000, 1500, "BARO" )
A2ADispatcher_BLUE:SetSquadronCapInterval( "KishBARCAP", 1, 1, 400, 1 )
A2ADispatcher_BLUE:SetSquadronCapRacetrack("KishBARCAP", 20000, 25000, 3, 5, 40*50, 30*60)

A2ADispatcher_BLUE:SetSquadronCap( "KishBIGDADDY", DeepBlueZone, 3000, 12000, 800, 1100, 1000, 1500, "BARO" )
A2ADispatcher_BLUE:SetSquadronCapInterval( "KishBIGDADDY", 1, 1, 1200, 1 )


A2ADispatcher_BLUE:SetSquadronCap( "SasCARGO", MainBlueZone, 3000, 12000, 800, 1100, 1000, 1500, "BARO" )
A2ADispatcher_BLUE:SetSquadronCapInterval( "SasCARGO", 2, 1, 1200, 1 )



--------------------////SQUADRON GROUPING

A2ADispatcher_BLUE:SetSquadronGrouping( "LarSTRIKE", 2 )

A2ADispatcher_BLUE:SetSquadronGrouping( "KishCAP", 2 )
A2ADispatcher_BLUE:SetSquadronGrouping( "KishBARCAP", 1 )
A2ADispatcher_BLUE:SetSquadronGrouping( "KishBIGDADDY",1 )

A2ADispatcher_BLUE:SetSquadronGrouping( "SasCARGO", 1 )




--------------------////SQUADRON OVERHEAD (1.0-1.5)


A2ADispatcher_BLUE:SetSquadronOverhead( "LarSTRIKE", 1.5)

A2ADispatcher_BLUE:SetSquadronOverhead( "KishCAP", 2.0)
A2ADispatcher_BLUE:SetSquadronOverhead( "KishBARCAP", 0.5)
A2ADispatcher_BLUE:SetSquadronOverhead( "KishBIGDADDY", 1.0)

A2ADispatcher_BLUE:SetSquadronOverhead( "SasCARGO", 2.0)


-------------------- RTB ON FUEL


A2ADispatcher_BLUE:SetSquadronFuelThreshold( "LarSTRIKE", 0.50 )

A2ADispatcher_BLUE:SetSquadronFuelThreshold( "KishCAP", 0.50 )
A2ADispatcher_BLUE:SetSquadronFuelThreshold( "KishBARCAP", 0.40 )
A2ADispatcher_BLUE:SetSquadronFuelThreshold( "KishBIGDADDY", 0.80 )

A2ADispatcher_BLUE:SetSquadronFuelThreshold( "SasCARGO", 0.80 )
